/*  EQEMu:  Everquest Server Emulator
Copyright (C) 2001-2003  EQEMu Development Team (http://eqemulator.net)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY except by those people which sell it, which
are required to give you total support for your newly bought product;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  04111-1307  USA
*/
#ifndef EQ_OPCODES_H
#define EQ_OPCODES_H

// Invalid opcodes have been \t'd out, confirmed have no \t

//////////////////////////////////////
// Zone.exe opcodes:
//////////////////////////////////////
//0x029f gives you money
//280 makes you stop receiving and sending chat messages
//260 send spell information
//45 logout
//72 player is in zone blah at dfdsfdsfg
//80 The door says
//89 Your expansion settings are:
//104 scribes a spell to your spellbook
//108,555 kicks player to server select
//123 money split from groups
//11 sense trap response
//296 name approval question
//338 failed to create new player guild
//401 pk question, 0x0191 response
//411 sacrifice question, 0x019b response
//193,213,243,244,431 chat messages
//425,499,505,506,525,526,596 crash
//451 translocate question, 0x01c3 response
//474,537 you escape from combat hiding yourself from view
//492 stat buffs
//496 your petition text is:
//528 you receive money msg with money
//562 you have control of yourself again
//613 CTD
//686 removes the unencumbered
#define OP_IncreaseStats	0x01ec
	#define OP_ApproveZone	0x0136
#define OP_Dye			0x01d7
	#define OP_ExpansionSetting	0x0203
	#define OP_GainMoney		0x0209
#define OP_Sacrifice		0x019b
#define OP_BecomePK			0x0191
#define OP_Stamina		    0x016a
#define OP_MobUpdate		0x003f
#define OP_ClientUpdate		0x0028
#define OP_ChannelMessage	0x0025
#define OP_SimpleMessage    0x01d9
#define OP_FormattedMessage 0x01da	
#define OP_RaidInvite		0x01e5
#define OP_RaidJoin			0x01e6
	#define OP_ApplyPoison		0x00b7
#define OP_TGB				0x01c7 // /tbg
#define OP_CharInfo			0x0013 // /charinfo
#define OP_Movelog			0x0280 // /movelog
#define OP_Beta				0x02bb // /beta
#define OP_TestBuff			0x0275 // /testbuffme
#define OP_Key				0x01e3 // /keys
#define OP_Bind_Wound		0x012f
#define OP_Begging			0x014e
#define OP_MoveCoin			0x0154
#define OP_SpawnDoor		0x0282
#define OP_Sneak			0x009e // Clicked sneak - Doodman 10/10/2003
#define OP_ExpUpdate		0x007a
#define OP_DumpName			0x026d //no idea what this is: just tired of looking at it as unknown; updated by Shawn319
#define OP_UpdateAA			0x0212
#define OP_RespondAA		0x01ec // AA table
#define OP_SendAAStats		0x01ca
#define OP_AAAction         0x01eb // Used for changing percent, buying? and activating skills
#define OP_BoardBoat		0x00bc
#define OP_LeaveBoat		0x00bd
#define OP_SendExpZonein		0x002c
#define OP_ZoneInSendName		0x01e6
#define OP_ZoneInSendName2		0x01c1
#define OP_ZoneComplete			0x0087 //Client sends upon successful zone in
/*Guild Opcodes*/
	#define OP_GuildLeader		 0x00a8 // /guildleader
	#define OP_GuildPeace		 0x009b // /guildpeace
	#define OP_GuildRemove		 0x0134 // /guildremove
#define OP_GuildMemberList   0x005a //fixed by Shawn319 (dec 18th patch)
#define OP_GuildMemberUpdate 0x025e //fixed by Shawn319 (dec 18th patch)
	#define OP_GuildPublicNote		0x003d
	#define OP_GuildDemote			0x0998

#define OP_GMDelCorpse		0x019a // /delcorpse

/*Bazaar*/
#define OP_Trader			0x01ea // /trader
#define OP_Bazaar			0x01e9 // /bazaar search
#define OP_BecomeTrader		0x01c5
#define	OP_BazaarInspect	0x01f7
	#define OP_TraderItemUpdate	0x0069
	#define	OP_TraderDelItem	0x017d
	#define OP_TraderShop		0x01ed	// right-click on a trader in bazaar
	#define OP_TraderBuy		0x01cb	// buy from a trader in bazaar
	
#define OP_PetCommands		0x01ad	// solar 9/1/03
#define OP_TradeSkillCombine 0x0043


/*Shops*/
#define OP_ShopPlayerBuy	0x0066
#define OP_ShopTakeMoney	0x0066
#define OP_ShopPlayerSell	0x006b
	#define OP_ShopEndConfirm	0x4541
#define OP_ShopRequest		0x00f9	// right-click on merchant
#define OP_ShopEnd			0x006d	// Finished shopping at merchant

	#define	OP_AdventureMerchantRequest	0x02c1
	#define	OP_AdventureMerchantResponse	0x02c2
	#define OP_AdventureMerchantPurchase	0x02c3
	#define OP_AdventurePointsUpdate		0x02d3

	#define OP_LFPCommand		     0x025b	// Looking for player
#define OP_LFPGetMatchesRequest  0x0261
#define OP_LFPGetMatchesResponse 0x0264

#define OP_LFGGetMatchesRequest  0x0263
#define OP_LFGGetMatchesResponse 0x0265
#define OP_LFGCommand		     0x0260	// When client issues /LFG command
#define OP_LFGResponse           0x01b2
	#define OP_LFGAppearance	0x01d1	// Some other char in zone turns LFG on/off

	#define OP_TradeMoneyUpdate	0x0164
	#define	OP_MoneyUpdate		0x01b6
#define OP_GroupUpdate		0x023a
#define OP_GroupInvite		0x024f
	#define OP_GroupDisband		0x0101 // solar 9/1/03 untested
	#define OP_GroupInvite2		0x00d6
#define OP_GroupFollow		0x024e
	#define OP_GroupFollow2		0x00d8 //DONT CHANGE
#define OP_AutoFollow		0x008d
	#define OP_CancelInvite		0x00d7
	#define OP_GroupDelete		0x9721
#define	OP_GroupAcknowledge	0x0262
#define OP_ConsiderCorpse	0x01d8
#define OP_SkillUpdate		0x0065
	#define OP_GMEndTrainingResponse 0x0178 
#define OP_GMEndTraining	0x013e //
#define OP_GMTrainSkill		0x0177 //
#define OP_GMTraining		0x013d // solar 9/1/03

#define OP_ConsumeAmmo		0x017d
#define OP_CombatAbility	0x0173

#define OP_TrackUnknown		0x009d
#define OP_TrackTarget		0x0224
#define OP_Track			0x0276	// Clicked Track - Doodman 10/10/2003
#define	OP_ReadBook			0x0287

#define OP_ItemLinkClick	0x0020
#define OP_ItemLinkResponse	0x01f7
#define OP_ItemLinkText		0x01da

	#define OP_RezzRequest		0x2a41
	#define OP_RezzAnswer		0x00e6
	#define OP_RezzComplete		0x019c

#define	OP_MoveDoor			0x012a
#define	OP_ClickDoor		0x0129	// Click door
#define OP_SendZonepoints	0x0237	// Coords in a zone that will port you to another zone
#define OP_SetRunMode		0x008d	// Client hit the "run" button (or control+r)
#define OP_InspectRequest	0x0238
#define OP_InspectAnswer	0x0239
	#define OP_SenseHeading		0x00c2	// Clicked sense heading button
	#define OP_SenseTraps		0x0187  // Clicked sense traps - @Doodman 10/10/2003
	#define OP_DisarmTraps		0x0186  // Clicked disarm traps - @Doodman 10/10/2003
#define OP_Assist			0x01bd // solar 9/1/03 untested
	#define OP_PickPocket		0x0258

#define OP_LootRequest		0x011b
#define OP_MoneyOnCorpse	0x011d
#define OP_LootComplete		0x017b
#define OP_EndLootRequest	0x011c
#define OP_LootItem			0x0141
#define OP_PlaceItem		0x0153	// Instruct client to put an item in a slot

	#define OP_Disciplines		0x0999
#define OP_WhoAllRequest   	0x0057
#define OP_WhoAllResponse   0x0219
#define OP_Consume			0x0169 // solar: untested
#define OP_AutoAttack		0x0174
#define OP_AutoAttack2		0x0187
#define OP_TargetMouse		0x0175	// mouse targetting a person (also: Pressing F* key to target)
#define OP_TargetCommand	0x01bb	// /target user
#define OP_TargetReject		0x01d9	// When /target fails (// solar: untested)
#define OP_Hide				0x009f
#define OP_Forage			0x0130 // Clicked forage  - @Doodman 10/10/2003
#define OP_Adventure		0x02e0 // /adventure
#define OP_Summoncorpse		0x02a5 // /summoncorpse
#define OP_Feedback			0x0163	// /feedback
#define OP_Bug				0x0236	// /bug
#define OP_Emote			0x00f4	// /me goes blah
#define OP_EmoteAnim		0x0142 // solar: untested
#define OP_Consider			0x015e
#define OP_FaceChange		0x01cc	// /face
#define OP_Petition			0x0069
#define OP_PDeletePetition	0x01ef
	#define OP_PetitionBug		0x008f
#define OP_PViewPetition	0x01ee
#define OP_Report			0x01e0
#define OP_RandomReq		0x0198
#define OP_RandomReply		0x0088
#define OP_Camp				0x01c4
#define OP_YellForHelp		0x0193
#define OP_SafePoint		0x00f1
#define OP_Jump				0x00d9
#define OP_Buff				0x0159
#define OP_BuffFadeMsg		0x00c1
#define OP_SpecialMesg		0x020c	// Communicate textual info to client
#define OP_Consent			0x0014	// /consent
#define OP_Stun				0x016E
#define OP_CastSpell		0x00bf
#define OP_InterruptCast	0x01a9
#define OP_Death			0x0107
#define OP_Find				0x02cb
#define OP_FindResponse		0x02cc
#define OP_FeignDeath		0x022F
#define OP_Illusion			0x012d
#define OP_LevelUpdate		0x0079
	#define OP_Split			0x007b
	#define OP_SearchCorpse		0x0099
	#define OP_LocateCorpse     0x00d1  //Sent when a client casts Locate Corpse spells?

#define OP_MemorizeSpell	0x00c3	// Memming a spell from book to spell slot
#define OP_BeginCast		0x0022
#define OP_HPUpdate			0x0234	// Update HP % of a PC or NPC
#define OP_SendHPTarget		0x021f
#define OP_Mend				0x007e
#define OP_MendHPUpdate		0x009c
#define OP_Taunt			0x0162

#define OP_PetitionRefresh	0x0086
#define OP_GMFind			0x0048	// GM /find			- ?
#define OP_GMServers		0x0021	// GM /servers		- ?
#define OP_GMGoto			0x010d	// GM /goto			- Transport to another loc
#define OP_GMSummon			0x027c	// GM /summon		- Summon PC to self
#define	OP_GMKick			0x010c	// GM /kick			- Boot player
#define OP_GMKill			0x010b	// GM /kill			- Insta kill mob/pc
#define OP_GMLastName		0x00a4	// GM /lastname		- Change user lastname
#define OP_GMToggle			0x01b4	// GM /toggle		- Toggle ability to receive tells from other PC's
#define OP_GMEmoteZone		0x027f	// GM /emotezone	- Send zonewide emote
#define OP_GMBecomeNPC		0x0075	// GM /becomenpc	- Become an NPC
// (TODO: Use opcode 0x012d, which is also sent with OP_GMBecomeNPC to create correct npc
#define OP_GMApproval		0x01b1	// GM /approval		- Name approval duty?
	#define OP_NameApproval		0x011f //Name approval
#define OP_GMSearchCorpse	0x0098	// GM /searchcorpse	- Search all zones for named corpse
#define OP_GMHideMe			0x00df	// GM /hideme		- Remove self from spawn lists and make invis
	#define OP_GMInquire		0x00d2	// GM /inquire		- Search soulmark data
	#define	OP_GMSoulmark		0x00d4	// GM /praise /warn	- Add soulmark comment to user file
#define OP_GMZoneRequest	0x0185	// GM /zone			- Transport to another zone
	#define OP_GMZoneRequest2	0x0229	// GM /zone 2
#define OP_PetitionUpdate	0x006a	// Updates the Petitions in the Que
#define OP_PetitionCheckout	0x0077	// Petition Checkout
#define OP_PetitionCheckout2 0x0057 //Also sent when a player checks out a petition Possibly requesting who all
#define OP_PetitionDelete	0x0092	// Client Petition Delete Request
#define OP_PetitionResolve	0x02a4	// Client Petition Resolve Request
#define OP_PetitionCheckIn	0x007f	// Petition Checkin
#define OP_PetitionUnCheckout 0x0091
#define OP_PetitionQue		0x0087 //GM looking at petitions

#define OP_SetServerFilter	0x01bc
	#define OP_SetServerFilterAck 0xc341

#define OP_EnvDamage		0x00ea	// 0.5.0-dr2: 0x00ec (changed to 0x0006 due to conflict)
#define OP_Damage			0x00e4
#define OP_Action			0x0103
#define OP_NewSpawn			0x0208	// New NPC or PC entering zone
#define OP_Animation		0x0142  // Might be incorrect still 
#define OP_MobHealth		0x021e	// health sent when a player clicks on the mob
#define OP_ZoneChange		0x0144	// Client requesting transfer to a different zone
#define OP_DeleteSpawn		0x00f5	// Remove a spawn from the current zone
#define OP_ConfirmDelete	0x0178	//Client sends this to server to confirm op_deletespawn
#define OP_NewCorpse		0x00da
		#define OP_CrashDump		0x0265
#define OP_CastOn			0x0119
#define OP_CastBuff			0x00e4
#define OP_ManaChange		0x00c0
#define OP_ClientError		0x026c
	#define OP_LoadSpellSet		0x02bb
#define OP_Save				0x00fd	// Client asking server to save user state
#define OP_Surname			0x0189
#define OP_SwapSpell		0x0190	// Swapping spell positions within book
#define OP_ShopItem			0x02d0	// Send merchant item data to client (header = 0x64)
#define OP_CloseContainer	0x028f	// 10-10-2003	Client closing world container (i.e., forge)
#define OP_ClickObjectAck	0x028f	// 10-10-2003	Client closing world container (i.e., forge)
#define OP_CreateObject		0x00fc	// 10-10-2003	Zone objects (pok books, objects on ground, etc)
#define	OP_ClickObject		0x00fb	// 10-10-2003	Client clicking on object
	#define OP_ClearObject		0x01c2
	#define OP_GuildMOTD		0x01c0	// /guildmotd
	#define OP_GuildManagement	0x005e	// LoY guild mgm't tool
#define OP_ZoneUnavail		0x0255

#define OP_ItemPacket		0x02d0	// Variety of ways for sending out item data
#define OP_MoveItem		0x0153	// Client moving an item from one slot to another (user action)
	//0x0283 hmm
	#define OP_TradeRequest		0x028a	// Client request trade session
	#define OP_TradeRequestAck	0x0038	// Trade request recipient is acknowledging they are able to trade
	#define OP_TradeAcceptClick	0x002e
	#define OP_ItemToTrade		0x0031
	#define OP_TradeCoins		0x0037
	#define OP_CancelTrade		0x002f
	#define OP_FinishTrade		0x0030
	#define OP_Translocate		0x01C6
#define OP_WebUpdate		0x01f2
#define OP_SaveOnZoneReq    0x00a2
#define OP_Logout           0x016c  // Last opcode seny by server when you zone or camp
#define	OP_RequestDuel		0x0288 //Shawn319: Fixed 1/3/04
#define OP_DuelResponse		0x0289
#define OP_DuelResponse2	0x0170

//////////////////////////////////////
// Zone.exe opcodes for login sequence:
//////////////////////////////////////
#define OP_SetDataRate		0x0199	// Client sending datarate.txt value
#define OP_ZoneEntry		0x022b	// Info about char entering zone..
#define OP_PlayerProfile	0x006c	// Basic player info (no inventory)
#define OP_CharInventory	0x0281	// Full inventory of player
#define OP_ZoneSpawns		0x0172	// All spawns in current zone
#define	OP_TimeOfDay		0x0027	// Notify client of current time
#define OP_Weather			0x015d	// Weather update
#define OP_ReqNewZone		0x00ee	// Client requesting NewZone_Struct
#define OP_NewZone			0x00ed	// Info about zone being loaded (exp multiplier, etc)
#define OP_ReqClientSpawn	0x00ff	// Client requesting spawn data
#define OP_SpawnAppearance	0x0131	// Sets spawnid/animation/equipment
#define OP_ClientReady		0x0087	// Client fully connected, finished loading

//////////////////////////////////////
// World.exe opcodes:
//////////////////////////////////////
#define OP_LoginComplete		0x02db
#define OP_AckPacket			0x0018	// Appears to be generic ack at the presentation level
#define OP_ApproveWorld			0x0196
#define OP_LogServer			0x0188
#define OP_MOTD					0x01b3	// Server message of the day
#define OP_SendLoginInfo		0x0241
#define OP_DeleteCharacter		0x00ec	// Delete character @ char select
#define OP_SendCharInfo			0x0104	// Send all chars visible @ char select
#define OP_ExpansionInfo		0x00e3	// Which expansions user has
#define OP_CharacterCreate		0x0106	// Create character @ char select
#define OP_RandomNameGenerator	0x029b	// Returns a random name
#define OP_GuildsList			0x005e	// Server sending client list of guilds
#define OP_ApproveName			0x0127	// Approving new character name @ char creation
#define OP_EnterWorld			0x0251	// Server approval for client to enter world
#define OP_World_Client_CRC1	0x015c	// Contains a snippet of spell data
#define OP_World_Client_CRC2	0x0160	// Second client verification packet
#define OP_SetChatServer		0x0259	// Chatserver? IP,Port,servername.Charname,password(?)
#define OP_ZoneServerInfo		0x0254	// Zone server? IP,0's,int16?
	#define OP_UserCompInfo		0x02a5	// User submitting computer information
#define OP_DeleteSpell			0x01dd

//////////////////////////////////////
// Zone.exe/World.exe shared opcodes:
//////////////////////////////////////
#define OP_WearChange		0x012e	// Client texture/color update


////////////////////////////
// OLD opcodes:
////////////////////////////

	

	#define OP_GuildInviteAccept 0x0133

	#define OP_GuildWar			0x00a5 // /guildwar
	#define OP_GuildInvite		0x0132 // /guildinvite

	#define OP_GuildUpdate		0x7b41
	#define OP_MultiLineMsg		0x1440
	#define OP_GMNameChange		0xcb40 // /name

	#define OP_SummonedItem		0x7841

	#define OP_HarmTouch		0x7E41
	#define OP_InstillDoubt		0x9c41
	#define OP_ControlBoat		0x2641
	#define OP_Drink			0x4641
	#define OP_SafeFallSuccess	0xab41

	

	


	
	#define OP_Medding			0x5841
	#define OP_Charm			0x4442

	#define PET_BACKOFF			1
	#define PET_GETLOST			2
	#define PET_HEALTHREPORT	4
	#define PET_GUARDHERE		5
	#define PET_GUARDME			6
	#define PET_ATTACK			7
	#define PET_FOLLOWME		8
	#define PET_SITDOWN			9
	#define PET_STANDUP			10
	#define PET_TAUNT			11
	#define PET_LEADER			16


// Agz: The following is from the old source I used as base
/************ ENUMERATED PACKET OPCODES ************/
	#define ALL_FINISH                  0x0005
	#define LS_REQUEST_VERSION          0x0059
	#define LS_SEND_VERSION             0x0059
	#define LS_SEND_LOGIN_INFO          0x0001
	#define LS_SEND_SESSION_ID          0x0004
	#define LS_REQUEST_UPDATE           0x0052
	#define LS_SEND_UPDATE              0x0052

	#define LS_REQUEST_SERVERLIST       0x0046
	#define LS_SEND_SERVERLIST          0x0046

	#define LS_REQUEST_SERVERSTATUS     0x0048
	#define LS_SEND_SERVERSTATUS        0x004A
	#define LS_GET_WORLDID              0x0047
	#define LS_SEND_WORLDID             0x0047
	#define WS_SEND_LOGIN_INFO          0x5818
	#define WS_SEND_LOGIN_APPROVED      0x0710
	#define WS_SEND_LOGIN_APPROVED2     0x0180
	#define WS_SEND_CHAR_INFO           0x4720
#endif
